<?php

header('Content-Type: application/json; charset=UTF-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Credentials: true');
header('Access-Control-Allow-Methods: POST,GET,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

ini_set("display_errors", 1);

require_once "connection.php"; // CONNECTION FILE
require_once "miradatar_functions.php"; // CONSTANT FILE

$json = file_get_contents('php://input',true);
    // Converts it into a PHP object
    $post = json_decode($json,true);
    if(empty($post)){
        $post = isset($_REQUEST) ? $_REQUEST : "";
    }
    
$postFile = '';
$result = array();
$case = isset($post['case']) ? $post['case'] : "";

if ($case != '' && !empty($post)) {
    switch ($case) {
        case "addEditUserData":
            $result = addEditUserData($post);
            $jsonData = json_encode($result);
            break;
        case "checkUserLogin":
            $result = checkUserLogin($post);
            $jsonData = json_encode($result);
            break;
        case "addEditAddressData":
            $result = addEditAddressData($post);
            $jsonData = json_encode($result);
            break;
        case "addEditScheduleData":
            $result = addEditScheduleData($post);
            $jsonData = json_encode($result);
            break;
        case "getVariantData":
            $result = getVariantData($post);
            $jsonData = json_encode($result);
            break;
        case "addEditProductData":
            $result = addEditProductData($post,$_FILES);
            $jsonData = json_encode($result);
            break;
        case "addEditProductVariantData":
            $result = addEditProductVariantData($post);
            $jsonData = json_encode($result);
            break;
        case "removeProductVariantData":
            $result = removeProductVariantData($post);
            $jsonData = json_encode($result);
            break;
        case "getProductUomData":
            $result = getProductUomData($post);
            $jsonData = json_encode($result);
            break;
        case "getUserDetailsByUserId":
            $result = getUserDetailsByUserId($post);
            $jsonData = json_encode($result);
            break;
        case "getConfigData":
            $result = getConfigData($post);
            $jsonData = json_encode($result);
            break;
        case "getProductDataByCategoryId":
            $result = getProductDataByCategoryId($post);
            $jsonData = json_encode($result);
            break;
        case "addEditInquiry":
            $result = addEditInquiry($post);
            $jsonData = json_encode($result);
            break;
        case "addEditSubscribe":
            $result = addEditSubscribe($post);
            $jsonData = json_encode($result);
            break;
        default :
            $result = array("status" => FAIL, "message" => "Please Check Api.");
            $jsonData = json_encode($result);
    }
}else{
    $result = array("status" => FAIL, "message" => "Please Check Api.");
    $jsonData = json_encode($result);
}
if ($jsonData) {
    echo $jsonData;
} else {
    $result = array('status' => FAIL, "message" => "No Record Found.");
    echo json_encode($result);
}
?>
