<?php
function truncateString($string, $length, $stopanywhere=false) {
    //truncates a string to a certain char length, stopping on a word if not specified otherwise.
    if (strlen($string) > $length) {
        //limit hit!
        $string = substr($string,0,($length -3));
        if ($stopanywhere) {
            //stop anywhere
            $string .= '...';
        } else{
            //stop on a word.
            $string = substr($string,0,strrpos($string,' ')).'...';
        }
    }
    return $string;
}
function getYoutubeEmbedUrl($url)
{
     $shortUrlRegex = '/youtu.be\/([a-zA-Z0-9_-]+)\??/i';
$longUrlRegex = '/youtube.com\/((?:embed)|(?:watch))((?:\?v\=)|(?:\/))([a-zA-Z0-9_-]+)/i';

    if (preg_match($longUrlRegex, $url, $matches)) {
        $youtube_id = $matches[count($matches) - 1];
    }

    if (preg_match($shortUrlRegex, $url, $matches)) {
        $youtube_id = $matches[count($matches) - 1];
    }
    return 'https://www.youtube.com/embed/' . $youtube_id ;
}

function addEditProfileData($postData) {
    global $db;
    $profile_id = isset($postData['profile_id']) ? $postData['profile_id'] : '1';
    $website_name = isset($postData['website_name']) ? $postData['website_name'] : '';
    $owner_name = isset($postData['owner_name']) ? $postData['owner_name'] : '';
    $owner_number = isset($postData['owner_number']) ? $postData['owner_number'] : '';
    $office_number = isset($postData['office_number']) ? $postData['office_number'] : '';
    $email = isset($postData['email']) ? $postData['email'] : '';
    $address = isset($postData['address']) ? $postData['address'] : '';
    $pincode = isset($postData['pincode']) ? $postData['pincode'] : '';
    $state = isset($postData['state']) ? $postData['state'] : '';
    $country = isset($postData['country']) ? $postData['country'] : '';
    $bank_name = isset($postData['bank_name']) ? $postData['bank_name'] : '';
    $ifsc_code = isset($postData['ifsc_code']) ? $postData['ifsc_code'] : '';
    $account_number = isset($postData['account_number']) ? $postData['account_number'] : '';
    $facebook = isset($postData['facebook']) ? $postData['facebook'] : '';
    $instagram = isset($postData['instagram']) ? $postData['instagram'] : '';
    $google = isset($postData['google']) ? $postData['google'] : '';
    $twitter = isset($postData['twitter']) ? $postData['twitter'] : '';
    $youtube = isset($postData['youtube']) ? $postData['youtube'] : '';
    $website_url = isset($postData['website_url']) ? $postData['website_url'] : '';
    $footer_widget_script = isset($postData['footer_widget_script']) ? $postData['footer_widget_script'] : '';
    $about_footer_text = isset($postData['about_footer_text']) ? $postData['about_footer_text'] : '';

    $fileUplodPath = "../" . UPLOAD_PATH . LOGO_IMAGE_PATH;
    $imageUplodPath = '';
    if ($_FILES['exampleInputFile']['name']) {
        $word = 'LOGO_IMG';
        $type = 'jpeg,gif,png,jpg';
        list($file, $error) = upload('exampleInputFile', $fileUplodPath, $type, $word);
        //if($error) print $error;
        $imageUplodPath = "/" . UPLOAD_PATH . LOGO_IMAGE_PATH . $file;
        if ($error) {
            $imageUplodPath = '';
            $result = array("status" => FAIL, "msg" => $error);
            return $result;
        }
    }
    
    $fileUplodPath = "../" . UPLOAD_PATH . LOGO_IMAGE_PATH;
    $logo_pngPath = '';
    if ($_FILES['logo_png']['name']) {
        $word = 'LOGO_PNG_IMG';
        $type = 'jpeg,gif,png,jpg';
        list($file, $error) = upload('logo_png', $fileUplodPath, $type, $word);
        //if($error) print $error;
        $logo_pngPath = "/" . UPLOAD_PATH . LOGO_IMAGE_PATH . $file;
        if ($error) {
            $logo_pngPath = '';
            $result = array("status" => FAIL, "msg" => $error);
            return $result;
        }
    }
    
    $fileUplodPath = "../" . UPLOAD_PATH . LOGO_IMAGE_PATH;
    $faviconPath = '';
    if ($_FILES['favicon']['name']) {
        $word = 'FAVICON_IMG';
        $type = 'jpeg,gif,png,jpg';
        list($file, $error) = upload('favicon', $fileUplodPath, $type, $word);
        //if($error) print $error;
        $faviconPath = "/" . UPLOAD_PATH . LOGO_IMAGE_PATH . $file;
        if ($error) {
            $faviconPath = '';
            $result = array("status" => FAIL, "msg" => $error);
            return $result;
        }
    }
    
    if (!empty($profile_id)) {
        $data = [
            'website_name' => $website_name,
            'owner_name' => $owner_name,
            'owner_number' => $owner_number,
            'office_number' => $office_number,
            'email' => $email,
            'address' => $address,
            'pincode' => $pincode,
            'state' => $state,
            'country' => $country,
            'bank_name' => $bank_name,
            'ifsc_code' => $ifsc_code,
            'account_number' => $account_number,
            'facebook' => $facebook,
            'instagram' => $instagram,
            'google' => $google,
            'twitter' => $twitter,
            'youtube' => $youtube,
            'about_footer_text' => $about_footer_text,
            'footer_widget_script' => $footer_widget_script,
            'website_url' => $website_url,
            'update_time' => date('Y-m-d h:i:s')
        ];
         if ($imageUplodPath != '') {
            $data['logo'] = $imageUplodPath;
        }
        if ($logo_pngPath != '') {
            $data['logo_png'] = $logo_pngPath;
        }
        if ($faviconPath != '') {
            $data['favicon'] = $faviconPath;
        }
        $db->where('profile_id', $profile_id);
        if ($db->update(Profile_Master, $data)) {
            $result = array("success" => SCS, "msg" => "Profile Details Updated Successfully.", "profile_id" => $profile_id);
        } else {
            $result = array("success" => FAIL, "msg" => "Sorry !!! Profile Details Not Updated.", "profile_id" => $profile_id);
        }
    } else {
        $data = [
            'youtube_name' => $youtube_name,
            'youtube_url' => $youtube_url,
            'youtube_description' => $youtube_description,
            'youtube_iframe_code' => mysql_real_escape_string($youtube_iframe_code),
            'insert_time' => date('Y-m-d h:i:s'),
            'update_time' => date('Y-m-d h:i:s'),
            'is_active' => 1,
            'is_deleted' => '0'
        ];
        $id = $db->insert(Profile_Master, $data);
        if ($id) {
            $result = array("success" => SCS, "msg" => "Profile Inserted Successfully.");
        } else {
            $result = array("success" => FAIL, "msg" => "Sorry !!! Profile Details Not Inserted.");
        }
    }
    return $result;
}

function addEditYoutubeData($postData) {
    global $db;
    $youtube_id = isset($postData['youtube_id']) ? $postData['youtube_id'] : '';
    $youtube_category_id = isset($postData['youtube_category_id']) ? $postData['youtube_category_id'] : '';
    $youtube_name = isset($postData['youtube_name']) ? $postData['youtube_name'] : '';
    $youtube_url = isset($postData['youtube_url']) ? $postData['youtube_url'] : '';
    $youtube_iframe_code = isset($postData['youtube_iframe_code']) ? $postData['youtube_iframe_code'] : '';
    $youtube_description = isset($postData['youtube_description']) ? $postData['youtube_description'] : '';

    if (!empty($youtube_id)) {
        $data = [
            'youtube_category_id' => $youtube_category_id,
            'youtube_name' => $youtube_name,
            'youtube_url' => $youtube_url,
            'youtube_description' => $youtube_description,
            'youtube_iframe_code' => mysql_real_escape_string($youtube_iframe_code),
            'insert_time' => date('Y-m-d h:i:s'),
            'update_time' => date('Y-m-d h:i:s'),
            'is_active' => 1,
            'is_deleted' => '0'
        ];
        $db->where('youtube_id', $youtube_id);
        if ($db->update(Youtube_Master, $data)) {
            $result = array("success" => SCS, "msg" => "Youtube Video Details Updated Successfully.");
        } else {
            $result = array("success" => FAIL, "msg" => "Sorry !!! Youtube Video Details Not Updated.");
        }
    } else {
        $data = [
            'youtube_category_id' => $youtube_category_id,
            'youtube_name' => $youtube_name,
            'youtube_url' => $youtube_url,
            'youtube_description' => $youtube_description,
            'youtube_iframe_code' => mysql_real_escape_string($youtube_iframe_code),
            'insert_time' => date('Y-m-d h:i:s'),
            'update_time' => date('Y-m-d h:i:s'),
            'is_active' => 1,
            'is_deleted' => '0'
        ];
        $id = $db->insert(Youtube_Master, $data);
        if ($id) {
            $result = array("success" => SCS, "msg" => "Youtube Video Inserted Successfully.");
        } else {
            $result = array("success" => FAIL, "msg" => "Sorry !!! Youtube Video Details Not Inserted.");
        }
    }
    return $result;
}

function addEditTeamData($postData) {
    global $db;
    $team_id = isset($postData['team_id']) ? $postData['team_id'] : '';
    $team_name = isset($postData['team_name']) ? $postData['team_name'] : '';
    $team_mobile = isset($postData['team_mobile']) ? $postData['team_mobile'] : '';
    $team_email = isset($postData['team_email']) ? $postData['team_email'] : '';
    $team_landline = isset($postData['team_landline']) ? $postData['team_landline'] : '';
    $team_facebook = isset($postData['team_facebook']) ? $postData['team_facebook'] : '';
    $team_twitter = isset($postData['team_twitter']) ? $postData['team_twitter'] : '';
    $team_instagram = isset($postData['team_instagram']) ? $postData['team_instagram'] : '';
    $team_youtube = isset($postData['team_youtube']) ? $postData['team_youtube'] : '';
    $team_linkedin = isset($postData['team_linkedin']) ? $postData['team_linkedin'] : '';
    $team_destination = isset($postData['team_destination']) ? $postData['team_destination'] : '';
    $team_description = isset($postData['team_description']) ? $postData['team_description'] : '';
    $team_google = isset($postData['team_google']) ? $postData['team_google'] : '';
    $team_address = isset($postData['team_address']) ? $postData['team_address'] : '';
    
    $fileUplodPath = "../" . UPLOAD_PATH . TEAM_IMAGE_PATH;
    $imageUplodPath = '';
    if ($_FILES['exampleInputFile']['name']) {
        $word = 'TEAM_IMG';
        $type = 'jpeg,gif,png,jpg';
        list($file, $error) = upload('exampleInputFile', $fileUplodPath, $type, $word);
        //if($error) print $error;
        $imageUplodPath = "/" . UPLOAD_PATH . TEAM_IMAGE_PATH . $file;
        if ($error) {
            $imageUplodPath = '';
            $result = array("status" => FAIL, "msg" => $error);
            return $result;
        }
    }

    if (!empty($team_id)) {
        $data = [
            'team_name' => $team_name,
            'team_mobile' => $team_mobile,
            'team_email' => $team_email,
            'team_landline' => $team_landline,
            'team_facebook' => $team_facebook,
            'team_twitter' => $team_twitter,
            'team_instagram' => $team_instagram,
            'team_youtube' => $team_youtube,
            'team_linkedin' => $team_linkedin,
            'team_google' => $team_google,
            'team_address' => $team_address,
            'team_destination' => $team_destination,
            'team_description' => $team_description,
            'team_insert_time' => date('Y-m-d h:i:s'),
            'team_update_time' => date('Y-m-d h:i:s'),
            'is_active' => 1,
            'is_deleted' => '0'
        ];
        if ($imageUplodPath != '') {
            $data['team_image'] = $imageUplodPath;
        }
        $db->where('team_id', $team_id);
        if ($db->update(Team_Master, $data)) {
            $result = array("success" => SCS, "msg" => "Team Member Details Updated Successfully.");
        } else {
            $result = array("success" => FAIL, "msg" => "Sorry !!! Team Member Details Not Updated.");
        }
    } else {
        $data = [
            'team_name' => $team_name,
            'team_mobile' => $team_mobile,
            'team_email' => $team_email,
            'team_landline' => $team_landline,
            'team_facebook' => $team_facebook,
            'team_twitter' => $team_twitter,
            'team_instagram' => $team_instagram,
            'team_youtube' => $team_youtube,
            'team_linkedin' => $team_linkedin,
            'team_google' => $team_google,
            'team_address' => $team_address,
            'team_destination' => $team_destination,
            'team_description' => $team_description,
            'team_insert_time' => date('Y-m-d h:i:s'),
            'team_update_time' => date('Y-m-d h:i:s'),
            'is_active' => 1,
            'is_deleted' => '0'
        ];
        if ($imageUplodPath != '') {
            $data['team_image'] = $imageUplodPath;
        }
        $id = $db->insert(Team_Master, $data);
        if ($id) {
            $result = array("success" => SCS, "msg" => "Team Member Inserted Successfully.");
        } else {
            $result = array("success" => FAIL, "msg" => "Sorry !!! Team Member Details Not Inserted.");
        }
    }
    return $result;
}


function addEditGalleryData($postData) {
    global $db;
    $gallery_id = isset($postData['gallery_id']) ? $postData['gallery_id'] : '';
    $gallery_name = isset($postData['gallery_name']) ? $postData['gallery_name'] : '';
    $category_id = isset($postData['category_id']) ? $postData['category_id'] : '';
    
    $fileUplodPath = "../" . UPLOAD_PATH . GALLERY_IMAGE_PATH;
    $imageUplodPath = '';
    if ($_FILES['exampleInputFile']['name']) {
        $word = 'GAL_IMG';
        $type = 'jpeg,gif,png,jpg';
        list($file, $error) = upload('exampleInputFile', $fileUplodPath, $type, $word);
        //if($error) print $error;
        $imageUplodPath = "/" . UPLOAD_PATH . GALLERY_IMAGE_PATH . $file;
        if ($error) {
            $imageUplodPath = '';
            $result = array("status" => FAIL, "msg" => $error);
            return $result;
        }
    }

    if (!empty($gallery_id)) {
        $data = [
            'gallery_category_id' => $category_id,
            'gallery_name' => $gallery_name,
            'gallery_insert_time' => date('Y-m-d h:i:s'),
            'gallery_update_time' => date('Y-m-d h:i:s'),
            'is_active' => 1,
            'is_deleted' => '0'
        ];
        if ($imageUplodPath != '') {
            $data['gallery_image'] = $imageUplodPath;
        }
        $db->where('gallery_id', $gallery_id);
        if ($db->update(Gallery_Master, $data)) {
            $result = array("success" => SCS, "msg" => "Gallery Details Updated Successfully.");
        } else {
            $result = array("success" => FAIL, "msg" => "Sorry !!! Gallery Details Not Updated.");
        }
    } else {
        $data = [
            'gallery_category_id' => $category_id,
            'gallery_name' => $gallery_name,
            'gallery_insert_time' => date('Y-m-d h:i:s'),
            'gallery_update_time' => date('Y-m-d h:i:s'),
            'is_active' => 1,
            'is_deleted' => '0'
        ];
        if ($imageUplodPath != '') {
            $data['gallery_image'] = $imageUplodPath;
        }
        $id = $db->insert(Gallery_Master, $data);
        if ($id) {
            $result = array("success" => SCS, "msg" => "Gallery Inserted Successfully.");
        } else {
            $result = array("success" => FAIL, "msg" => "Sorry !!! Gallery Details Not Inserted.");
        }
    }
    return $result;
}

function addEditPostCategoryData($postData) {
    global $db;
    $category_id = isset($postData['category_id']) ? $postData['category_id'] : '';
    $category_type = isset($postData['category_type']) ? $postData['category_type'] : '';
    $category_name_GU = isset($postData['category_name_GU']) ? $postData['category_name_GU'] : '';
    $category_name_HI = isset($postData['category_name_HI']) ? $postData['category_name_HI'] : '';
    $category_name_EN = isset($postData['category_name_EN']) ? $postData['category_name_EN'] : '';

    $fileUplodPath = "../" . UPLOAD_PATH . POST_CATEGORY_IMAGE_PATH;
    $imageUplodPath = '';
    if ($_FILES['exampleInputFile']['name']) {
        $word = 'CAT_IMG';
        $type = 'jpeg,gif,png,jpg';
        list($file, $error) = upload('exampleInputFile', $fileUplodPath, $type, $word);
        //if($error) print $error;
        $imageUplodPath = "/" . UPLOAD_PATH . POST_CATEGORY_IMAGE_PATH . $file;
        if ($error) {
            $imageUplodPath = '';
            $result = array("status" => FAIL, "msg" => $error);
            return $result;
        }
    }

    if (!empty($category_id)) {
        $data = [
            'category_type' => $category_type,
            'category_name_GU' => $category_name_GU,
            'category_name_HI' => $category_name_HI,
            'category_name_EN' => $category_name_EN,
            'is_active' => 1,
            'is_deleted' => '0'
        ];
        if ($imageUplodPath != '') {
            $data['category_image'] = $imageUplodPath;
        }
        $db->where('category_id', $category_id);
        if ($db->update(Category_Master, $data)) {
            $result = array("success" => SCS, "msg" => "Category Details Updated Successfully.");
        } else {
            $result = array("success" => FAIL, "msg" => "Sorry !!! Category Details Not Updated.");
        }
    } else {
        $data = [
            'category_type' => $category_type,
            'category_name_GU' => $category_name_GU,
            'category_name_HI' => $category_name_HI,
            'category_name_EN' => $category_name_EN,
            'is_active' => 1,
            'is_deleted' => '0'
        ];
        if ($imageUplodPath != '') {
            $data['category_image'] = $imageUplodPath;
        }
        $id = $db->insert(Category_Master, $data);
        if ($id) {
            $result = array("success" => SCS, "msg" => "Category Registered Successfully.");
        } else {
            $result = array("success" => FAIL, "msg" => "Sorry !!! Category Details Not Inserted.");
        }
    }
    return $result;
}

function addEditPostData($postData, $fileData) {
    global $db;
    $post_id = isset($postData['post_id']) ? $postData['post_id'] : '';
    $post_name_EN = isset($postData['post_name_EN']) ? $postData['post_name_EN'] : '';
    $post_name_GU = isset($postData['post_name_GU']) ? $postData['post_name_GU'] : '';
    $post_name_HI = isset($postData['post_name_HI']) ? $postData['post_name_HI'] : '';
    $category_id = isset($postData['category_id']) ? $postData['category_id'] : '';
    $description_EN = isset($postData['description_EN']) ? $postData['description_EN'] : '';
    $description_GU = isset($postData['description_GU']) ? $postData['description_GU'] : '';
    $description_HI = isset($postData['description_HI']) ? $postData['description_HI'] : '';
    $post_type = isset($postData['post_type']) ? $postData['post_type'] : '';

    $fileUplodPath = "../" . UPLOAD_PATH . POST_IMAGE_PATH;
    $imageUplodPath = '';
    if ($_FILES['exampleInputFile']['name']) {
        $word = 'PRO_IMG';
        $type = 'jpeg,gif,png,jpg';
        list($file, $error) = upload('exampleInputFile', $fileUplodPath, $type, $word);
        //if($error) print $error;
        $imageUplodPath = "/" . UPLOAD_PATH . POST_IMAGE_PATH . $file;
        if ($error) {
            $imageUplodPath = '';
            $result = array("status" => FAIL, "msg" => $error);
            return $result;
        }
    }

    if (!empty($post_id)) {
        $data = [
            'post_name_EN' => $post_name_EN,
            'post_name_GU' => $post_name_GU,
            'post_name_HI' => $post_name_HI,
            'category_id' => $category_id,
            'description_EN' => $description_EN,
            'description_GU' => $description_GU,
            'description_HI' => $description_HI,
            'post_type' => $post_type,
            'is_active' => '1',
            'is_deleted' => '0'
        ];
        if ($imageUplodPath != '') {
            $data['post_image'] = $imageUplodPath;
        }
        $db->where('post_id', $post_id);
        if ($db->update(Post_Master, $data)) {
            $result = array("success" => SCS, "msg" => "post Details Updated Successfully.");
        } else {
            $result = array("success" => FAIL, "msg" => "Sorry !!! post Details Not Updated.");
        }
    } else {
        $data = [
            'post_name_EN' => $post_name_EN,
            'post_name_GU' => $post_name_GU,
            'post_name_HI' => $post_name_HI,
            'category_id' => $category_id,
            'description_EN' => $description_EN,
            'description_GU' => $description_GU,
            'description_HI' => $description_HI,
            'post_type' => $post_type,
            'is_active' => '1',
            'is_deleted' => '0'
        ];
        if ($imageUplodPath != '') {
            $data['post_image'] = $imageUplodPath;
        }
        $id = $db->insert(Post_Master, $data);
        if ($id) {
            $result = array("success" => SCS, "msg" => "post Registered Successfully.");
        } else {
            $data = array();
            $result = array("success" => FAIL, "msg" => "Sorry !!! post Details Not Inserted.");
        }
    }
    return $result;
}

function upload($file_id, $folder = "", $types = "", $word) {
    global $userId;
    if (!$_FILES[$file_id]['name'])
        return array('', 'No file specified');
    $file_title = $_FILES[$file_id]['name'];
    //Get file extension
    //$ext_arr = split("\.", basename($file_title));
    $ext_arr = explode(".", basename($file_title));
    $ext = strtolower($ext_arr[count($ext_arr) - 1]); //Get the last extension
    //Not really uniqe - but for all practical reasons, it is
    $uniqer = substr(md5(uniqid(rand(), 1)), 0, 5);
    $file_name = $word . '_' . time() . '_' . $file_title; //Get Unique Name

    $all_types = explode(",", strtolower($types));
    if ($types) {
        if (in_array($ext, $all_types))
            ;
        else {
            $result = "'" . $_FILES[$file_id]['name'] . "' Is Not A Valid File."; //Show error if any.
            return array('', $result);
        }
    }

    //Where the file must be uploaded to
    if ($folder)
        $folder .= '/'; //Add a '/' at the end of the folder
    $uploadfile = $folder . $file_name;

    $result = '';
    //Move the file from the stored location to the new location
    if (!move_uploaded_file($_FILES[$file_id]['tmp_name'], $uploadfile)) {
        $result = "Cannot upload the file '" . $_FILES[$file_id]['name'] . "'"; //Show error if any.
        if (!file_exists($folder)) {
            $result .= " : Folder don't exist.";
        } elseif (!is_writable($folder)) {
            $result .= " : Folder not writable.";
        } elseif (!is_writable($uploadfile)) {
            $result .= " : File not writable.";
        }
        $file_name = '';
    } else {
        if (!$_FILES[$file_id]['size']) { //Check if the file is made
            @unlink($uploadfile); //Delete the Empty file
            $file_name = '';
            $result = "Empty file found - please use a valid file."; //Show the error message
        } else {
            chmod($uploadfile, 0777); //Make it universally writable.
        }
    }

    return array($file_name, $result);
}

function getPostDataByCategoryId($postData) {
    global $db;
    $category_id = isset($postData['category_id']) ? $postData['category_id'] : '';
    $user_language = isset($postData['user_language']) ? $postData['user_language'] : '';
    $postData = array();
    if(!empty($category_id)){
         $postData = $db->rawQuery("SELECT PM.post_id,PM.category_id,PM.post_name_".$user_language." AS post_name,PM.post_code,PM.uom_id,UM.uom_name,CONCAT('".PROJECT_ROOT."', PM.post_image) AS post_image,PM.description_".$user_language." AS description,PM.stock_qty,PM.is_stock FROM " . post_Master . " PM INNER JOIN ".Uom_Master." UM ON PM.uom_id = UM.uom_id WHERE PM.is_deleted = '0' AND PM.is_active = '1' AND PM.category_id = '".$category_id."'");
        $result = array("success" => SCS, "msg" => "post Data Found.", "category_id" => $category_id, "postData" => $postData);
    }else{
        $result = array("success" => FAIL, "msg" => "Please Enter Valid Details.");
    }
    return $result;
}

function addEditBannerData($postData) {
    global $db;
    $banner_id = isset($postData['banner_id']) ? $postData['banner_id'] : '';
    $banner_button_text = isset($postData['banner_button_text']) ? $postData['banner_button_text'] : '';
    $banner_button_url = isset($postData['banner_button_url']) ? $postData['banner_button_url'] : '';
    $banner_description = isset($postData['banner_description']) ? $postData['banner_description'] : '';
    $banner_name = isset($postData['banner_name']) ? $postData['banner_name'] : '';
    
    $fileUplodPath = "../" . UPLOAD_PATH . BANNER_IMAGE_PATH;
    $imageUplodPath = '';
    if ($_FILES['exampleInputFile']['name']) {
        $word = 'BANNER_IMG';
        $type = 'jpeg,gif,png,jpg';
        list($file, $error) = upload('exampleInputFile', $fileUplodPath, $type, $word);
        //if($error) print $error;
        $imageUplodPath = "/" . UPLOAD_PATH . BANNER_IMAGE_PATH . $file;
        if ($error) {
            $imageUplodPath = '';
            $result = array("status" => FAIL, "msg" => $error);
            return $result;
        }
    }

    if (!empty($banner_id)) {
        $data = [
            'banner_button_text' => $banner_button_text,
            'banner_button_url' => $banner_button_url,
            'banner_description' => $banner_description,
            'banner_name' => $banner_name,
            'banner_insert_time' => date('Y-m-d h:i:s'),
            'banner_update_time' => date('Y-m-d h:i:s'),
            'is_active' => 1,
            'is_deleted' => '0'
        ];
        if ($imageUplodPath != '') {
            $data['banner_image'] = $imageUplodPath;
        }
        $db->where('banner_id', $banner_id);
        if ($db->update(Banner_Master, $data)) {
            $result = array("success" => SCS, "msg" => "Banner Details Updated Successfully.");
        } else {
            $result = array("success" => FAIL, "msg" => "Sorry !!! Banner Details Not Updated.");
        }
    } else {
        $data = [
            'banner_button_text' => $banner_button_text,
            'banner_button_url' => $banner_button_url,
            'banner_description' => $banner_description,
            'banner_name' => $banner_name,
            'banner_insert_time' => date('Y-m-d h:i:s'),
            'banner_update_time' => date('Y-m-d h:i:s'),
            'is_active' => 1,
            'is_deleted' => '0'
        ];
        if ($imageUplodPath != '') {
            $data['banner_image'] = $imageUplodPath;
        }
        $id = $db->insert(Banner_Master, $data);
        if ($id) {
            $result = array("success" => SCS, "msg" => "Banner Inserted Successfully.");
        } else {
            $result = array("success" => FAIL, "msg" => "Sorry !!! Banner Details Not Inserted.");
        }
    }
    return $result;
}

function addEditInquiry($postData) {
    global $db;
    $name = isset($postData['name']) ? $postData['name'] : '';
    $email = isset($postData['email']) ? $postData['email'] : '';
    $mobile = isset($postData['mobile']) ? $postData['mobile'] : '';
    $message = isset($postData['message']) ? $postData['message'] : '';
    $inquiry_id = isset($postData['inquiry_id']) ? $postData['inquiry_id'] : '';

    if (!empty($inquiry_id)) {
        $data = [
            'name' => $name,
            'mobile' => $mobile,
            'email' => $email,
            'message' => $message,
            'inquiry_insert_time' => date('Y-m-d h:i:s'),
            'inquiry_update_time' => date('Y-m-d h:i:s'),
            'is_active' => 1,
            'is_deleted' => '0'
        ];
        $db->where('inquiry_id', $inquiry_id);
        if ($db->update(Inquiry_Master, $data)) {
            $result = array("success" => SCS, "msg" => "Inquiry Details Updated Successfully.");
        } else {
            $result = array("success" => FAIL, "msg" => "Sorry !!! Inquiry Details Not Updated.");
        }
    } else {
        $data = [
            'name' => $name,
            'mobile' => $mobile,
            'email' => $email,
            'message' => $message,
            'inquiry_insert_time' => date('Y-m-d h:i:s'),
            'inquiry_update_time' => date('Y-m-d h:i:s'),
            'is_active' => 1,
            'is_deleted' => '0'
        ];
        $id = $db->insert(Inquiry_Master, $data);
        if ($id) {
            $result = array("success" => SCS, "msg" => "Inquiry Inserted Successfully.");
        } else {
            $result = array("success" => FAIL, "msg" => "Sorry !!! Inquiry Details Not Inserted.");
        }
    }
    return $result;
}

function addEditSubscribe($postData) {
    global $db;
    $subscribe_mobile = isset($postData['subscribe_mobile']) ? $postData['subscribe_mobile'] : '';
    $subscribe_id = isset($postData['subscribe_id']) ? $postData['subscribe_id'] : '';

    if (!empty($subscribe_id)) {
        $data = [
            'subscribe_mobile' => $subscribe_mobile,
            'subscribe_insert_time' => date('Y-m-d h:i:s'),
            'subscribe_update_time' => date('Y-m-d h:i:s'),
            'is_active' => 1,
            'is_deleted' => '0'
        ];
        $db->where('subscribe_id', $subscribe_id);
        if ($db->update(Subscribe_Master, $data)) {
            $result = array("success" => SCS, "msg" => "Subscribe Details Updated Successfully.");
        } else {
            $result = array("success" => FAIL, "msg" => "Sorry !!! Subscribe Details Not Updated.");
        }
    } else {
        $data = [
            'subscribe_mobile' => $subscribe_mobile,
            'subscribe_insert_time' => date('Y-m-d h:i:s'),
            'subscribe_update_time' => date('Y-m-d h:i:s'),
            'is_active' => 1,
            'is_deleted' => '0'
        ];
        $id = $db->insert(Subscribe_Master, $data);
        if ($id) {
            $result = array("success" => SCS, "msg" => "Subscribe Inserted Successfully.");
        } else {
            $result = array("success" => FAIL, "msg" => "Sorry !!! Subscribe Details Not Inserted.");
        }
    }
    return $result;
}

function addEditSeoData($postData, $fileData) {
    global $db;
    $seo_id = isset($postData['seo_id']) ? $postData['seo_id'] : '';
    $page_id = isset($postData['page_id']) ? $postData['page_id'] : '';
    $page_name = isset($postData['page_name']) ? $postData['page_name'] : '';
    $page_main_title = isset($postData['page_main_title']) ? $postData['page_main_title'] : '';
    $seo_meta_title = isset($postData['seo_meta_title']) ? $postData['seo_meta_title'] : '';
    $seo_meta_keyword = isset($postData['seo_meta_keyword']) ? $postData['seo_meta_keyword'] : '';
    $seo_meta_description = isset($postData['seo_meta_description']) ? $postData['seo_meta_description'] : '';
    $page_description = isset($postData['page_description']) ? $postData['page_description'] : '';
    
    $fileUplodPath = "../" . UPLOAD_PATH . PAGE_BANNER_IMAGE_PATH;
    $imageUplodPath = '';
    if ($_FILES['exampleInputFile']['name']) {
        $word = 'PAGE_BANNER_IMG';
        $type = 'jpeg,gif,png,jpg';
        list($file, $error) = upload('exampleInputFile', $fileUplodPath, $type, $word);
        //if($error) print $error;
        $imageUplodPath = "/" . UPLOAD_PATH . PAGE_BANNER_IMAGE_PATH . $file;
        if ($error) {
            $imageUplodPath = '';
            $result = array("status" => FAIL, "msg" => $error);
            return $result;
        }
    }

    if (!empty($seo_id)) {
        $data = [
            'page_main_title' => $page_main_title,
            'seo_meta_title' => $seo_meta_title,
            'seo_meta_keyword' => $seo_meta_keyword,
            'seo_meta_description' => $seo_meta_description,
            'page_description' => $page_description,
            'seo_update_time' => date('Y-m-d h:i:s'),
            'is_active' => '1',
            'is_deleted' => '0'
        ];
        if ($imageUplodPath != '') {
            $data['page_image'] = $imageUplodPath;
        }
        $db->where('seo_id', $seo_id);
        if ($db->update(Seo_Master, $data)) {
            $result = array("success" => SCS, "msg" => "SEO Details Updated Successfully.");
        } else {
            $result = array("success" => FAIL, "msg" => "Sorry !!! SEO Details Not Updated.");
        }
    } else {
        $result = array("success" => FAIL, "msg" => "Sorry !!! You Have No Autorised For This Action.");
    }
    return $result;
}
?>
